#version 330
#extension GL_EXT_gpu_shader4 : enable
// Water Condensation on GlassMod01.fsh  by   D4v1D

//https://www.shadertoy.com/view/3sSyD3
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// based and inspired by Warping - procedural 4 (https://www.shadertoy.com/view/MdSXzz - by inigo quilez - iq/2014)
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// it's WORK IN PROGRESS!!

const mat2 m = mat2(0.81,0.60,-.9,.8);
float hash( vec2 p ) { float h = dot(p,vec2(127.1,311.7)); return -1.0 + 2.0*fract(sin(h)*43758.5453123); }

float noise( in vec2 p) 
{   vec2 i = floor(p);
    vec2 f = fract(p);
	vec2 u = f*f*(3.0-2.0*f);
    return mix(mix( hash( i + vec2(0.0,0.0) ), 
                     hash( i + vec2(1.0,0.0) ), u.x),
                mix( hash( i + vec2(0.0,1.0) ), 
                     hash( i + vec2(1.0,1.0) ), u.x), u.y); }

float fbm( vec2 p )
{   float f = 0.0;
    f += 0.30 * noise( p ); p = m*p*2.00;
 	f *= 0.700  + noise( p ); p = m*p*1.00;
    f *= 0.1250 + noise( p ); p = m*p*2.00;
    f += 0.1725 * noise( p );
    return f/0.9375; }

vec2 fbm2( in vec2 p )
{return vec2( fbm(p.yx), fbm(p.xy) );}

vec3 map( vec2 p )
{   p *= 0.7;
    float f = dot( fbm2( 1.0*(0.24*iTime - p + fbm2(-0.05*iTime+2.0*(p / fbm2(5.0*p)))) ), vec2(1.0,-1.0) ); // condensa
    float bl = smoothstep(-0.8, 0.8, f );
    float ti = smoothstep(0.0,1.0, fbm(p) );
    return mix( mix( vec3(0.1,0.0,.2),
                     vec3(1.0,1.0,0.0), ti ), 
                     vec3(1.0,1.0,1.0), bl );   }
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{   vec2 p = (-iResolution.xy+2.0*gl_FragCoord.xy)/iResolution.y;
    float e = 0.0045;
    vec3 colc = map(e-p);
    float gc = dot(colc,vec3(0.333));
    vec3 cola = map(p + vec2(e,0.0)); 
    float ga = dot(cola,vec3(0.333));
    vec3 colb = map(p + vec2(0.0,e));
    float gb = dot(colb,vec3(0.333));
    vec3 col = colc;
    col += vec3(0.1,0.1,.11)*1.0*abs(1.0*gc-ga-gb); // defines color for highlight in outlines/border
    vec2 q = -gl_FragCoord.xy/iResolution.xy; // this traces screen coordinates;
    col *= pow(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y),0.1);  // vignetting
    gl_FragColor = vec4( col, 1.0 );
}
